﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// EMS Notification class - stores all the configuration data about the EMS Notifications.
    /// </summary>
    public class EMSNotification 
    {
        /// <summary>
        /// Gets or sets the location of the EMS notification.
        /// </summary>
        /// <value>
        /// The location.
        /// </value>
        public string Location { get; set; }

        /// <summary>
        /// Gets or sets the EMS email.
        /// </summary>
        /// <value>
        /// The EMS email.
        /// </value>
        public string EMSEmail { get; set; }

        /// <summary>
        /// Gets or sets whether the EMS should be notified when a bed dirty event is raised.
        /// </summary>
        /// <value>
        /// The EMS dirty.
        /// </value>
        public CD EMSDirty { get; set; }

        /// <summary>
        /// Gets or sets whether the EMS should be notified when a bed cleaned event is raised.
        /// </summary>
        /// <value>
        /// The EMS cleaned.
        /// </value>
        public CD EMSCleaned { get; set; }

        /// <summary>
        /// Gets or sets the bed controller email.
        /// </summary>
        /// <value>
        /// The bed controller email.
        /// </value>
        public string BedControllerEmail { get; set; }

        /// <summary>
        /// Gets or sets whether the bed controller should be notified when a bed dirty event is raised.
        /// </summary>
        /// <value>
        /// The bed controller dirty.
        /// </value>
        public CD BedControllerDirty { get; set; }

        /// <summary>
        /// Gets or sets whether the bed controller should be notified when a bed cleaned event is raised.
        /// </summary>
        /// <value>
        /// The bed controller cleaned.
        /// </value>
        public CD BedControllerCleaned { get; set; }

        /// <summary>
        /// Gets or sets the vista mail group.
        /// </summary>
        /// <value>
        /// The vista group mail.
        /// </value>
        public string VistaGroupMail { get; set; }

        /// <summary>
        /// Gets or sets whether the vista group should be notified when a bed dirty event is raised.
        /// </summary>
        /// <value>
        /// The vista group dirty.
        /// </value>
        public CD VistaGroupDirty { get; set; }

        /// <summary>
        /// Gets or sets whether the vista group should be notified when a bed cleaned event is raised.
        /// </summary>
        /// <value>
        /// The vista group cleaned.
        /// </value>
        public CD VistaGroupCleaned { get; set; }
    }
}
